﻿var variableEditor = {
    currentData: null,
    isTXTFormat: false,
    isOECoding: false,
    currentIndex: 1,
    datatable: null,
    changeCategoryItems: null,

    initializeDataTable: function () {
        this.datatable = $(".v-variableTable").a4datatable({
            ajaxAction: a4.getSurveyAction("GetVariableEditorGridResult", "Analyze"),
            ajaxParams: { "variableData": variableEditor.currentData },
            displayColumnSelector: false,
            columns: [

                { "Name": "DisplayName", "Title": resources.VariableName, "Data": "DisplayName", "Class": "v-name", "Sortable": false },
                { "Name": "GetDisplayType", "Title": resources.QuestionType, "Data": "GetDisplayType", "Sortable": false },
                { "Name": "ShortName", "Title": resources.Text, "Data": "ShortName", "Sortable": false },
                { "Name": "PositionRecord", "Title": resources.Record, "Data": "PositionRecord", "Visible": variableEditor.isTXTFormat, "Sortable": false },
                { "Name": "PositionColumn", "Title": resources.Column, "Data": "PositionColumn", "Visible": variableEditor.isTXTFormat, "Sortable": false }
            ],
            toolBar: { Items: variableEditor.getToolBarItems(), DisplayMode: dataTables.filterDisplayMode.buttons },
            contextMenuItems: variableEditor.getContextMenuItems(),
            toolBarClick: function (event, data) {
                var rows = data.rows;
                var action = data.action;
                var names = [];

                for (var i = 0; i < rows.length; i++) {
                    names.push(rows[i].Name);
                }

                if (action == "delete") {
                    variableEditor.deleteItems(names);
                }

                switch (action) {
                    case "calculateAll":
                        variableEditor.calculateAll();
                        break;
                    case "reset":
                        variableEditor.resetPositions();
                        break;
                    case "calculate":
                        variableEditor.calculatePositions(names);
                        break;
                    case "moveUp":
                        variableEditor.moveItems(names, false);
                        break;
                    case "moveDown":
                        variableEditor.moveItems(names, true);
                        break;
                    case "moveTo":
                        variableEditor.showMoveToDialog(function (moveDown, moveToVariable) {
                            variableEditor.moveToItems(names, moveToVariable, moveDown);
                        });
                        break;
                    case "delete":
                        variableEditor.deleteItems(names);
                        break;
                }
            },
            contextMenuClick: function (event, data) {
                var row = data.row;
                var action = data.action;

                switch (action) {
                    case "moveUp":
                        variableEditor.moveItems([row.Name], false);
                        break;
                    case "moveDown":
                        variableEditor.moveItems([row.Name], true);
                        break;
                    case "moveTo":
                        variableEditor.showMoveToDialog(function (moveDown, moveToVariable) {
                            variableEditor.moveToItems([row.Name], moveToVariable, moveDown);
                        });
                        break;
                    case "editPositions":
                        variableEditor.showEditPositionDialog([row.Name]);
                        break;
                    case "delete":
                        variableEditor.deleteItems([row.Name]);
                        break;
                }
            }
        });
    },
    selectVariables: function (variableNames) {
        var selectedVariables = [];
        var variables = [];

        if (variableEditor.currentData)
            selectedVariables = JSON.parse(variableEditor.currentData);

        var id = 0;
        var column = 1;
        var rank = 1;
        var record = 1;

        _.each(variableNames, function (variableName, index) {
            if (variableName) {
                var variable = _.find(selectedVariables, function (variable) {
                    return variable.Name == variableName;
                });

                if (variable) {
                    id = variable.Id;
                    column = variable.PositionColumn;
                    rank = variable.PositionRank;
                    record = variable.PositionRecord;
                }
                else {
                    column = 1;
                    rank++;
                    record = 1;
                }

                variables.push({ "Id": id, "Name": variableName, "PositionColumn": column, "PositionRank": rank, "PositionRecord": record });
            }
        });

        if (variableNames) {
            a4.callServerMethod(a4.getSurveyAction("GetVariableEditorData", "Analyze"), { variables: JSON.stringify(variables) },
            function (result) {
                variableEditor.refreshGrid(result);
            });
        }
        else {
            variableEditor.refreshGrid("");
        }
    },
    moveItems: function (items, moveDown) {
        var variables = $.parseJSON(variableEditor.currentData);

        if (moveDown)
            variables = variables.reverse();

        var index = 0;
        var foundIndex = 0;
        var tmp = null;

        _.each(variables, function (v) {
            if (index != 0 && (foundIndex = _.indexOf(items, v.Name)) != -1) {
                tmp = variables[index];
                variables[index] = variables[index - 1];
                variables[index - 1] = tmp;
            }

            index++;
        });

        if (moveDown)
            variables = variables.reverse();

        variableEditor.refreshGrid(JSON.stringify(variables));
    },
    moveToItems: function (items, source, moveDown) {
        var variables = $.parseJSON(variableEditor.currentData);
        var variableNames = _.pluck(variables, "Name");
        
        var pairItems = {}; 
        if (moveDown) {
            variableNames = variableNames.reverse();
            variables = variables.reverse(); 
        }
        var sourceIndex = _.indexOf(variableNames, source);

        for (var i = 0; i < items.length; i++) {
            pairItems[i] = {"index":_.indexOf(variableNames, items[i]),"Name": items[i]}
        }

        var beforeSourceIndex = _.filter(pairItems, function (item) { return item["index"] > sourceIndex });
        var AfterSourceIndex = _.filter(pairItems, function (item) { return item["index"] <= sourceIndex });
        
        var lastItemList =  _.pluck(Array.prototype.concat(_.sortBy(beforeSourceIndex, "index").reverse(), _.sortBy(AfterSourceIndex, "index")),"Name");
      
        var foundIndex = null;
        var tmp = null;

        if (sourceIndex > -1) {
            _.each(lastItemList, function (name) {
                if ((foundIndex = _.indexOf(variableNames, name)) != -1 && foundIndex != sourceIndex) {
                    tmp = variables[sourceIndex];
                    variables.splice(sourceIndex, 0, variables[foundIndex]);

                    if (sourceIndex <= foundIndex)
                        foundIndex += 1;

                    variables.splice(foundIndex, 1);
                    variableNames = _.pluck(variables, "Name");
                }
            });

            if (moveDown)
                variables = variables.reverse();

            variableEditor.refreshGrid(JSON.stringify(variables));
        }
    },
    showMoveToDialog: function (callback) {
        var moveContainer = $("#moveToPanel").clone();
        var container = $('<div id="MoveVariableToPanel">').append(moveContainer.html().replace(/moveBeforeLocation/g, "moveBeforeLocationEdit").replace(/moveAfterLocation/g, "moveAfterLocationEdit"));

        var initContentFunction = function () {
            var editor = $("#MoveVariableToPanel");

            $(".v-moveToVariable", editor).a4autocomplete({
                data: $.parseJSON(variableEditor.currentData),
                valueProperty: "Name",
                labelProperty: "DisplayName"
            });
        }

        var validateContentFunction = function () {
            var editor = $("#MoveVariableToPanel");
            var valid = ($(".v-moveToVariable", editor).val() != "");

            if (!valid) {
                a4.showErrorMessage(resources.SelectVariable);
            }

            return valid;
        }

        var moveResources = {
            "Title": resources.MoveTo,
            "Message": container
        };

        modalDialog.showConfirmDialog(moveResources,
            function () {
                var editor = $("#MoveVariableToPanel");
                var location = $(".v-moveToLocation:checked", editor).val();
                var variable = $(".v-moveToVariable", container).attr("data-value");
                callback(location == "Below", variable);
            }, 260, 500, false, null, { initFunction: initContentFunction, validateFunction: validateContentFunction });
    },
    showEditPositionDialog: function (variableName, callback) {
        var variables = $.parseJSON(variableEditor.currentData);
        var variable = _.find(variables, function (v) { return v.Name == variableName });

        if (variable != null) {
            var editContainer = $("#editPositionPanel").clone();
            var container = $('<div id="EditPanel">').append(editContainer.html());

            var initContentFunction = function () {
                var editor = $("#EditPanel");
                $(".v-record", editor).val(variable.PositionRecord);
                $(".v-position", editor).val(variable.PositionColumn);
            }

            var validateContentFunction = function () {
                var editor = $("#EditPanel");
                var valid = false;
                var intRegex = /^\d+$/;
                var recordLabel = $(".v-recordContent span", editor).text();
                var positionLabel = $(".v-positionContent span", editor).text();

                if ($(".v-record", editor).val() == "")
                    a4.showErrorMessage(resources.FieldRequired.replace("{0}", recordLabel));
                else if ($(".v-position", editor).val() == "")
                    a4.showErrorMessage(resources.FieldRequired.replace("{0}", positionLabel));
                else if (!intRegex.test($(".v-record", editor).val()))
                    a4.showErrorMessage(resources.IsNotAInt + " '" + recordLabel + "'");
                else if (!intRegex.test($(".v-position", editor).val()))
                    a4.showErrorMessage(resources.IsNotAInt + " '" + positionLabel + "'");
                else
                    valid = true;

                return valid;
            }

            var editResources = {
                "Title": resources.EditPositions,
                "Message": container
            };

            modalDialog.showConfirmDialog(editResources,
                function () {
                    var editor = $("#EditPanel");
                    variable.PositionRecord = parseInt($(".v-record", editor).val(), 10);
                    variable.PositionColumn = parseInt($(".v-position", editor).val(), 10);
                    variableEditor.refreshGrid(JSON.stringify(variables));
                }
                , 260, 500, false, null,
                { initFunction: initContentFunction, validateFunction: validateContentFunction });
        }
    },
    deleteItems: function (items) {
        var variables = $.parseJSON(variableEditor.currentData);

        _.each(items, function (i) {
            variables = _.reject(variables, function (v) { return v.Name == i; });
        });

        variableEditor.refreshGrid(JSON.stringify(variables));
    },
    calculateAll: function () {
        var variables = $.parseJSON(variableEditor.currentData);
        var start = 1;
        var positionRecord = 1;
        var currentBlock = 0;
        var blockRemainingLength = 0;
        var maxRecordWidth = $("#MaxRecordWidth").val();
        var loopsInQuestionnaireOrder = $("#LoopsInQuestionnaireOrder").is(":checked");
        var dichotomizedMultiple = $("#DichotomizedMultiple").is(":checked");
        var dichotomizedMultipleIgnoreChoiceHearder = $("#DichotomizedIgnoreChoiceHeader").is(":checked");
        var allNumericCodes = $("#AllNumericCodes").is(":checked");
        var openEndsInRespondentRecord = $("#OpenEndsInRespondentRecord").is(":checked");

        _.every(variables, function (v) {
            var fieldLength = v.FieldLength * v.MaxMention;

            if (dichotomizedMultiple && v.IsDichotomizable) {
                fieldLength = (allNumericCodes && v.NumericChoicesCount > 0) ?
                    v.NumericChoicesCount :
                    (dichotomizedMultipleIgnoreChoiceHearder ? v.NumericChoicesCount : v.ChoicesCount);
            }

            if (openEndsInRespondentRecord) {
                fieldLength += v.OpenEndsLength;
            }

            if ((maxRecordWidth > 0) && (start == maxRecordWidth || (fieldLength + start - 1) > maxRecordWidth)) {
                positionRecord += 1;
                start = 1;
            }

            v.PositionRecord = positionRecord;
            v.PositionColumn = start;

            if (maxRecordWidth > 0 && fieldLength > maxRecordWidth) {
                var message = resources.CalculateAllOperationNotPossible;
                message = message.replace(/{(.*?)}/g, v.Name);
                a4.showErrorMessage(message);
                variableEditor.resetPositions();
                return false;
            }

            if (loopsInQuestionnaireOrder) {
                if (v.BlockId != currentBlock) {
                    start += blockRemainingLength;
                    v.PositionColumn = start;
                    blockRemainingLength = 0;
                }

                blockRemainingLength += fieldLength * (v.MaxLoopSize - 1); // First matrix was already added to start
                currentBlock = v.BlockId;

                start += fieldLength; //Don't count matrix for loops in questionnaire order
            }
            else {
                start += fieldLength * v.MaxLoopSize;
            }

            return true;
        });

        variableEditor.refreshGrid(JSON.stringify(variables));
    },
    calculatePositions: function (items) {
        var dichotomizedMultiple = $("#DichotomizedMultiple").is(":checked");
        var dichotomizedMultipleIgnoreChoiceHearder = $("#DichotomizedIgnoreChoiceHeader").is(":checked");
        var allNumericCodes = $("#AllNumericCodes").is(":checked");
        var openEndsInRespondentRecord = $("#OpenEndsInRespondentRecord").is(":checked");
        var loopsInQuestionnaireOrder = $("#LoopsInQuestionnaireOrder").is(":checked");
        var variables = $.parseJSON(variableEditor.currentData);
        var variableNames = _.pluck(variables, "Name");
        var start = 1;
        var positionRecord = 1;
        var index = 0;

        _.each(items, function (i) {
            index = _.indexOf(variableNames, i);

            if (index > 0) {
                var prevVariable = variables[index - 1];
                var fieldLength = prevVariable.FieldLength * prevVariable.MaxMention;

                if (dichotomizedMultiple && prevVariable.IsDichotomizable) {
                    fieldLength = (allNumericCodes && prevVariable.NumericChoicesCount > 0) ?
                        prevVariable.NumericChoicesCount :
                        (dichotomizedMultipleIgnoreChoiceHearder ? prevVariable.NumericChoicesCount : prevVariable.ChoicesCount);
                }

                if (openEndsInRespondentRecord) {
                    fieldLength += prevVariable.OpenEndsLength;
                }

                variables[index].PositionColumn = prevVariable.PositionColumn + (fieldLength * (loopsInQuestionnaireOrder ? 1 : prevVariable.MaxLoopSize));
            }
        });

        variableEditor.refreshGrid(JSON.stringify(variables));
    },
    resetPositions: function () {
        var variables = $.parseJSON(variableEditor.currentData);

        _.each(variables, function (v) {
            v.PositionRecord = 1;
            v.PositionColumn = 1;
        });

        variableEditor.refreshGrid(JSON.stringify(variables));
    },
    refreshGrid: function (data) {
        variableEditor.currentData = data;

        if (variableEditor.datatable) {
            variableEditor.datatable.a4datatable("option", "ajaxParams", { "variableData": data, "sort": false });
            variableEditor.datatable.a4datatable("refresh");
        }
        else {
            variableEditor.initializeDataTable();
        }

        a4.parent().SetResponsesSelection(data);
    },
    getToolBarItems: function () {
        return [{ "Action": "calculateAll", "Label": resources.CalculateAllPositions, "Visible": variableEditor.isTXTFormat, "DisplayMode": dataTables.itemDisplayMode.nonSelected },
                { "Action": "reset", "Label": resources.ResetPositions, "Visible": variableEditor.isTXTFormat, "DisplayMode": dataTables.itemDisplayMode.nonSelected },
                { "Action": "delete", "Label": resources.Delete },
                { "Action": "moveUp", "Label": resources.MoveUp },
                { "Action": "moveDown", "Label": resources.MoveDown },
                { "Action": "moveTo", "Label": resources.MoveTo },
                { "Action": "calculate", "Label": resources.CalculatePositions, "Visible": variableEditor.isTXTFormat }];
    },
    getContextMenuItems: function () {
        return [{ "Action": "moveUp", "Label": resources.MoveUp },
        { "Action": "moveDown", "Label": resources.MoveDown },
        { "Action": "moveTo", "Label": resources.MoveTo },
        { "Action": "editPositions", "Label": resources.EditPositions, "Visible": variableEditor.isTXTFormat },
        { "Action": "delete", "Label": resources.Delete }];
    },
    showVariableSelector: function () {
        var variableSelectorParams = {
            variables: "",
            showSystemVariables: true,
            limitRowCount: variableEditor.isOECoding ? 1 : -1,
            showFilters: !variableEditor.isOECoding,
            onlyOpenEnds: variableEditor.isOECoding
        };

        modalDialog.showWindow(a4.getSurveyAction("VariableSelector", "Shared", variableSelectorParams), 620, 950, {
            beforeClose: function () {
                var variableSelector = $('.fancybox-iframe').contents();
                var confirmed = variableSelector.find(".v-confirmed").val();
                if (confirmed) {
                    var variableNames = $('.v-selectedVariables', variableSelector).val().split(",");
                    variableEditor.selectVariables(variableNames);

                    variableNames = variableNames.filter(function (variableName) {
                        return variableName !== "";
                    });

                    if (variableNames.length) {
                        $("#variableSelectorContainerError", exportResponsesWizard.context).hide();
                    }
                }
            }
        });
    },
    initVariableEditor: function () {
        variableEditor.isTXTFormat = $("#ExtractFormat").val() == "TXT";
        variableEditor.isOECoding = $("#ExtractFormat").val() == "OpenEndForCoding";

        variableEditor.currentData = $("#JSONVariables").val();
            variableEditor.initializeDataTable();
    }
}